# 스레드와 프로세스

Q. 스레드는 무엇인가요? 

Q. 멀티 프로세스는 무엇인가요?

- 
    
    동시에 진행된다는 것은 무슨 의미인가요?
    

- 용어 정리
    1. **실행 단위** : cpu core에서 실행하는 하나의 단위로 프로세스와 스레드를 포괄하는 개념 (즉, 실행 단위가 프로세스일 수도 있고, 스레드일 때도 있음!)
    2. **동시성** : 한 순간에 여러가지 일이 아니라, **짧은 전환으로 여러가지 일을 동시에 처리하는 것처럼**! 보이는 것

- **프로그램**이란?
    
    Program은 실행 파일!
    
    파일 시스템에 존재하는 파일! 이 파일에는 컴퓨터가 수행해야 할 작업이 정의되어 있음. 일반적으로 특정 작업을 수행하는데 필요한 알고리즘과 데이터 처리 절차를 적은 소스 코드가 담겨있음. 
    

- **프로세스**란?
    
    프로세스는 사용자가 프로그램을 더블클릭하여 실행을 시킨 프로그램의 인스턴스를 의미한다. 
    

프로그램 → 프로세스를 위한 과정?

1. 프로세스가 필요로 하는 내용들이 메모리 공간을 확보하게 됨
    - Code : 실행 명령을 포함
    - Data : Static 변수 혹은 Global 변수
    - Heap : 동적 메모리 영역
    - Stack : 지역변수, 매개변수, 반환 값 등등 일시적인 데이터
2. 해당 프로세스에 대한 정보를 담고 있는 PCB(Process Control Block)가 프로세스 생성시 함께 만들어짐. 
    
    ![images-jaypyon-post-07fba9e1-fa48-4d40-a3d8-203264539b70-image.png](%E1%84%89%E1%85%B3%E1%84%85%E1%85%A6%E1%84%83%E1%85%B3%E1%84%8B%E1%85%AA%20%E1%84%91%E1%85%B3%E1%84%85%E1%85%A9%E1%84%89%E1%85%A6%E1%84%89%E1%85%B3%20d7a7e990656f407088c223bd5a3ab1f0/images-jaypyon-post-07fba9e1-fa48-4d40-a3d8-203264539b70-image.png)
    

그렇다면 여러 개의 프로세스를 실행시키려면?

**Context Switching**

- CPU는 한 번에 하나의 프로세스만 처리할 수 있기 때문에!
- 여러 프로세스를 처리해야 하는 상황에서 현재 진행 중인 Task의 상태를 PCB에 저장하고 다음에 진행할 Task의 상태 값을 읽어 적용하는 과정
- 즉, 각 프로세스에게 CPU를 할당해 작업을 수행하는 과정
- but, 복잡해!!
    
    ![994590345BB1B4DB2F.jpeg](%E1%84%89%E1%85%B3%E1%84%85%E1%85%A6%E1%84%83%E1%85%B3%E1%84%8B%E1%85%AA%20%E1%84%91%E1%85%B3%E1%84%85%E1%85%A9%E1%84%89%E1%85%A6%E1%84%89%E1%85%B3%20d7a7e990656f407088c223bd5a3ab1f0/994590345BB1B4DB2F.jpeg)
    

→ 그래서 나온 게 **쓰레드**!

** 멀티 프로세스와 멀티 스레드는 처리 방식의 일종!

 한 어플리케이션에 대한 두 가지 다른 처리방식에 대한 이야기를 하는 거구나!라고 이해하고 시작하자.

- 프로세스는 부모 프로세스가 fork()하여 자식 프로세스를 만들고, 이를 처리하게 됨. 이 때 자식 프로세스들은 부모와 별개의 메모리를 차지하게 됨.
- 반면, 스레드는 한 프로세스 내에서 구분 지어진 실행 단위!

- **Multi-process** :
    - 각 프로세스는 독립적
    - IPC(Inter Process Communication)를 사용한 통신
    - 자원 소모적, 개별 메모리 차지 (별도의 자원 할당)
    - Context Switching 비용이 큼
    - 동기화 작업이 필요하지 않음

- **Multi-thread**: 하나의 프로세스를 다수의 스레드로 구분하여 자원을 공유하고 자원의 생성과 관리의 중복성을 최소화하여 수행 능력을 향상시키는 것
- Thread끼리 긴밀한 연결
- 공유된 자원으로 통신 비용 절감
- 공유된 자원으로 메모리가 효율적
- Context Switching 비용이 적음
- 공유 자원 관리를 해야함

그렇다면 thread를 이용하는 것이 더 좋아보이는데?

but, 스레드는 긴밀하게 연결되어 있기 때문에 한 스레드 문제가 생기면 다른 스레드도 영향을 받음.

또한 **동기화 문제**도 발생할 수 있음.

![img.jpg](%E1%84%89%E1%85%B3%E1%84%85%E1%85%A6%E1%84%83%E1%85%B3%E1%84%8B%E1%85%AA%20%E1%84%91%E1%85%B3%E1%84%85%E1%85%A9%E1%84%89%E1%85%A6%E1%84%89%E1%85%B3%20d7a7e990656f407088c223bd5a3ab1f0/img.jpg)

- c.f) **Multi-core** : 하드웨어즉 측면에 가까운 개념.
    
    물리적으로 여러 코어를 사용하여 다수의 실행 단위를 병렬적으로 한 순간에 처리할 수 있도록 하는 것. 하나의 코어를 갖고 있다면 멀티 프로세스에 대해 짧은 텀으로 cpu 할당을 바꿔주어 마치 동시에 진행되는 것처럼 보이게 하는 것.
